<?php
/* --------------------------------------------------------------
   NestedArrayHelper.php 2026-01-06
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2026 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

/**
 * Helper class for safe nested array access
 * Replaces eval()-based array access with secure traversal methods
 */
class NestedArrayHelper
{
    /**
     * Get value from nested array using path keys
     * @param array $array The array to traverse
     * @param array $keys Path keys ['Category', 'Subcategory', 'ID']
     * @return mixed|null Value at path or null if not found
     */
    public static function get(array &$array, array $keys)
    {
        if (empty($keys)) {
            return null;
        }

        $current = &$array;
        foreach ($keys as $key) {
            if (!is_array($current) || !array_key_exists($key, $current)) {
                return null;
            }
            $current = &$current[$key];
        }
        return $current;
    }

    /**
     * Set value in nested array using path keys
     * @param array $array The array to modify
     * @param array $keys Path keys
     * @param mixed $value Value to set
     */
    public static function set(array &$array, array $keys, $value): void
    {
        if (empty($keys)) {
            return;
        }

        $current = &$array;
        foreach ($keys as $key) {
            if (!isset($current[$key]) || !is_array($current[$key])) {
                $current[$key] = [];
            }
            $current = &$current[$key];
        }
        $current = $value;
    }
}
